// Script for NOAD Utility
// (c) Shamrock Software GmbH 2007-2025
// Thou Shalt Not Change This File!

var wmt=null, wmTimer;
document.onmousemove = updwmt; // For tooltip

function init()
{ if (document.getElementById)
  { ShowPage(1); SetType();
    if (document.f.cdc_list.value.length>0) document.f.cdc_on_board.checked=true;
    SetID(); DspList(true); DspList(false); DspCDC();
    FillOpts(document.f.class_society,agencies); SetOption(document.f.class_society,clsoc);
    FillOpts(document.f.comp_agency,agencies); SetOption(document.f.comp_agency,ccag);
    FillOpts(document.f.sfty_agency,agencies); SetOption(document.f.sfty_agency,sfag);
    FillOpts(document.f.vsclass,classes); SetOption(document.f.vsclass,vclass);
    FillOpts(document.f.fuel_type,fuel_types); SetOption(document.f.fuel_type,fuel_type);
    SubList(document.f.vsclass,typest,document.f.type,types);
    SetOption(document.f.type,type);
    SubList(document.f.type,subtypest,document.f.subtype,subtypes);
    SetOption(document.f.subtype,subtype);
    FillOpts(document.f.state,usstates); SetOption(document.f.state,state);
    SubList(document.f.state, usportst, document.f.port_name, usports);
    SetOption(document.f.port_name,port);
    if (document.f.port_name.selectedIndex<1) document.f.place.value=port;
    FillOpts(document.f.flag,countries); SetOption(document.f.flag,flag);
    FillOpts(document.f.next_country,countries);
    SetOption(document.f.next_country,next_country);
    FillOpts(document.f.previous_country1,countries);
    SetOption(document.f.previous_country1,prevctry[0]);
    FillOpts(document.f.previous_country2,countries);
    SetOption(document.f.previous_country2,prevctry[1]);
    FillOpts(document.f.previous_country3,countries);
    SetOption(document.f.previous_country3,prevctry[2]);
    FillOpts(document.f.previous_country4,countries);
    SetOption(document.f.previous_country4,prevctry[3]);
    FillOpts(document.f.previous_country5,countries);
    SetOption(document.f.previous_country5,prevctry[4]);
    SetFPorts(document.f.previous_country1,document.f.previous_port_name1);
    SetOption(document.f.previous_port_name1,prevport[0]);
    SetFPorts(document.f.previous_country2,document.f.previous_port_name2);
    SetOption(document.f.previous_port_name2,prevport[1]);
    SetFPorts(document.f.previous_country3,document.f.previous_port_name3);
    SetOption(document.f.previous_port_name3,prevport[2]);
    SetFPorts(document.f.previous_country4,document.f.previous_port_name4);
    SetOption(document.f.previous_port_name4,prevport[3]);
    SetFPorts(document.f.previous_country5,document.f.previous_port_name5);
    SetOption(document.f.previous_port_name5,prevport[4]);
    SetStates (document.f.next_country,document.f.next_state);
    SetOption(document.f.next_state,next_state);
    SetPorts  (document.f.next_country,document.f.next_state,document.f.next_port);
    SetOption(document.f.next_port,next_port);
    for(i=0; i<un_numbers.length; i++)
    { document.cdcf.un_numbers.options[i+1].value=un_numbers[i]
    }
    for(i=0; i<units.length; i++)
    { document.cdcf.cdc_u.options[i+1].value=units[i]
    }
    for(i=0; i<visa_codes.length; i++) // Set values of Visa status
    { document.nwf.visa_st.options[i+1].value=visa_codes[i]
    }
    if (document.f.rep_email.value=='')
     document.f.rep_email.value=document.f.user.value.toLowerCase()+'@skyfile.com';
    SetLongShore();
    if (document.f.file.value.length>5) document.f.useport.checked=true;
    if (oldid!='') AskType(1);
  } else alert("Sorry, you will need a newer web browser to use this form.")
}

// Show or hide tooltip
function help(t)
{ if (t!='')
  { wmt=document.getElementById('help');
    wmt.innerHTML=t;
    wmTimer=setTimeout('if(wmt.style.left)wmt.style.display="block"',250)
  } else
  { clearTimeout(wmTimer); wmt.style.display="none"
} }

// Set tooltip position to mouse pointer
function updwmt(e)
{ if (wmt!=null)
  { var x=document.all ? window.event.x+document.body.scrollLeft:e.pageX;
    var y=document.all ? window.event.y+document.body.scrollTop :e.pageY;
    wmt.style.left=(x+7)+"px"; wmt.style.top=(y+7)+"px"
} }

// Set Notice ID
function SetID()
{ var c,s;
  if (document.f.notice_transaction_type.selectedIndex==0) s=newid; // Initial
  else if (oldid!='') s=oldid; // Update or Canceled
  else { document.f.notice_transaction_type.selectedIndex=0; s=newid } // No old ID: Force initial
  document.getElementById("myid").innerHTML=s;
  document.f.notice_id.value=s
}

// Error in e-mail address?
function MailErr(s)
{ var j=true, k, valch='@.-_%#!+~';
  if (s.indexOf('@')>0 && s.lastIndexOf('.')>2  && s.indexOf('..')<0 && s.length>5)
  { j=false;
    for (i=0; i<s.length; i++)
    { k=s.charAt(i);
      if ((k<'a'||k>'z')&&(k<'A'||k>'Z')&&(k<'0'||k>'9') && valch.indexOf(k)<0)
      { j=true; break
  } } } return j
}

// Show page no. j
function ShowPage(j)
{ var i,s1,s2,s3,s4,x,b,s5;
  ShowBox (0,0); ShowCDC(0);
  b=document.f.key.value; i=b.indexOf(',');
  if (i>0 && b.length>18) // Ship name from license key
   document.getElementById('vessel').innerHTML=b.substr(0,i);
  for (i=1; i<10; i++)
  { if (i==j) { s1="block"; s2="#0066aa"; s3="0px"; s4="0px",s5="normal"}
    else  { s1="none";  s2="#001c39"; s3="0px"; s4="0px"; s5="normal" }
    document.getElementById("page_"+i).style.display=s1;
    x=document.getElementById("tab_"+i);
    b=" solid #001c39"; x.style.borderTop=s3+b;
    x.style.borderLeft=s3+b; x.style.borderRight=s3+b;
    x.style.borderBottom=s4+b; x.style.backgroundColor=s2;
    x.style.fontWeight=s5;
    window.focus()
} }

// Change elements for arrival or departure
function SetType()
{ var a,d,i,n;
  AskType(0); // Transaction type=initial?
  if (document.f.notice_type.selectedIndex != 0)
  { a="none"; d="inline" } else  { d="none"; a="inline" }
  for (i=0; i<document.getElementsByTagName("SPAN").length; i++)
  { n=document.getElementsByTagName("SPAN")[i].id;
    if (n.substr(0,4)=="arr-") document.getElementById(n).style.display=a;
    else if (n.substr(0,4)=="dep-") document.getElementById(n).style.display=d;
} }

// Show or hide entry box for crew or passengers
function ShowBox(v,crew)
{ var x,y,w,p=0;
  w=document.getElementById("ent");
  if (v) // Show
  { y="block"; w.style.position="absolute";
    w.style.left="50px"; w.style.top="70px";
  } else { y="none"; document.nwf.nr.value=-1 } // Hide
  w.style.display=y;
  if (v)
  { if (crew) { y="visible"} else { y="hidden" }
    document.getElementById("ent_p").style.visibility=y;
    document.getElementById("ent_v1").style.visibility=y;
    document.getElementById("ent_v2").style.visibility=y;
    if (crew && document.f.longshoreman_work_declaration.selectedIndex==1) 
     y="visible"; else y="hidden";
    document.getElementById("ent_ls1").style.visibility=y;
    document.getElementById("ent_ls2").style.visibility=y;
    if (document.nwf.nation.length==0) // Fill selection boxes
    { FillOpts(document.nwf.nation,countries);
      FillOpts(document.nwf.resid,countries);
      FillOpts(document.nwf.emb_c,countries);
      FillOpts(document.nwf.deb_c,countries)
      FillOpts(document.nwf.id_c,countries);
      FillOpts(document.nwf.addr_state,usstates)
    } document.nwf.lastn.focus()
  } else
  { document.nwf.lastn.value=''; document.nwf.middl.value='';
    document.nwf.first.value=''; document.nwf.birth.value='';
    document.nwf.id_nr.value=''; document.nwf.exp_date.value='';
    document.nwf.crew_p.selectedIndex=0;
    document.nwf.visa_st.selectedIndex=0;
    document.nwf.visa_fo.value=''; document.nwf.visa_co.value='';
    document.nwf.lsm.selectedIndex=0;
    ClrAddr()
} }

// Show or hide US address window
function ShowAddr(v)
{ var w;
  w=document.getElementById("usaddr");
  if (v) // Show
  { y="block"; w.style.position="absolute";
    w.style.left="350px"; w.style.top="210px";
  } else { y="none" } // Hide
  w.style.display=y;
}

// Clears U.S. address fields
function ClrAddr()
{ document.nwf.addr_state.selectedIndex=0;
  document.nwf.addr_city.value='';
  document.nwf.addr_zip.value='';
  document.nwf.addr_street.value=''
}

// Show or hide CDC entry box
function ShowCDC(v)
{ var y,w,p=0;
  w=document.getElementById("cdc");
  if (v)
  { y="block"; w.style.position="absolute";
    w.style.left="80px"; w.style.top="80px";
  } else { y="none"; document.cdcf.nr.value=-1 }
  w.style.display=y;
  if (v)
  { if (document.cdcf.cdc_c.length==0) FillOpts(document.cdcf.cdc_c,countries);
    document.cdcf.un_numbers.focus()
  } else
  { document.cdcf.un_numbers.selectedIndex=0;
    document.cdcf.cdc_a.value=''; document.cdcf.cdc_u.selectedIndex=0;
} }

// Adds or edits passenger or crew entry depending on nr field
function AddEntry()
{ var e,i,j,k,x,n,crew,ym=DtStr(),inv=';|<>"';
  var arr=new Array(),f=new Array()
  if(document.getElementById("ent_p").style.visibility=="hidden")
    crew=false; else crew=true;
  if (crew) f[0]=GetOption(document.nwf.crew_p); else f[0]='-';
  allow(document.nwf.lastn,".,` '-");
  allow(document.nwf.first,".,` '-");
  allow(document.nwf.middl,".,` '-");
  allow(document.nwf.id_nr," #-");
  allow(document.nwf.addr_street,".,` '-");
  allow(document.nwf.addr_city,".,` '-");
  allow(document.nwf.addr_zip,".,` '-");
  allow(document.nwf.visa_fo,".,` '-");
  allow(document.nwf.visa_co,"+");
  allow(document.nwf.cabin,". '-");
  allow(document.nwf.phone,". '-+");
  f[1]=document.nwf.lastn.value;
  f[2]=document.nwf.first.value;
  f[3]=document.nwf.middl.value;
  f[4]=document.nwf.birth.value;
  f[5]=GetOption(document.nwf.sex);
  f[6]=GetOption(document.nwf.nation);
  f[7]=GetOption(document.nwf.resid);
  f[8]=GetOption(document.nwf.id_type);
  f[9]=document.nwf.id_nr.value;
  f[10]=GetOption(document.nwf.id_c);
  f[11]=GetOption(document.nwf.emb_c);
  f[12]=GetOption(document.nwf.emb_s);
  f[13]=GetOption(document.nwf.emb_port);
  f[14]=document.nwf.emb_place.value;
  f[15]=document.nwf.emb_date.value;
  f[16]=GetOption(document.nwf.deb_c);
  f[17]=GetOption(document.nwf.deb_s);
  f[18]=GetOption(document.nwf.deb_port);
  f[19]=document.nwf.deb_place.value;
  f[20]=document.nwf.deb_date.value;
  f[21]=document.nwf.exp_date.value;
  i=document.nwf.visa_st.selectedIndex;
  if (i>0) f[22]=visa_codes[i-1]; else f[22]='';
  f[23]=document.nwf.visa_fo.value;
  f[24]=document.nwf.visa_co.value;
  f[25]=document.nwf.addr_street.value;
  f[26]=document.nwf.addr_city.value;
  f[27]=GetOption(document.nwf.addr_state);
  f[28]=document.nwf.addr_zip.value;
  f[29]=document.nwf.cabin.value;
  f[30]=document.nwf.phone.value;
  f[31]=GetOption(document.nwf.lsm);
  if (f[1].length<2)
  { alert('Missing last name'); document.nwf.lastn.focus(); return }
  if (!ValidDate(f[4],false) || f[4]>ym)
  { alert('Missing birth date or format error'); document.nwf.birth.focus(); return }
  if (f[21]!='' && !ValidDate(f[21]))
  { alert('Format error in ID expiration date'); document.nwf.exp_date.focus(); return }
  if (!ValidDate(f[15],false) || f[15]>ym)
  { alert('Missing embark date or format error'); document.nwf.emb_date.focus(); return }
  if (f[10].length<2)
  { alert('Missing ID country'); document.nwf.id_c.focus(); return }
  for (i=0; i<f.length; i++) // Delimiters disallowed in text
  { for (k=0; k<inv.length; k++)
    { if (f[i])
      { j=f[i].indexOf(inv.substr(k,1));
        if (j>=0) f[i]=f[i].substring(0,j)+f[i].substring(j+1);
  } } }
  if (crew) x=document.f.crew_list; else x=document.f.psgr_list;
  e=f.join(';');
  if (x.value.length!=0) arr=x.value.split('|');
  n=parseInt(document.nwf.nr.value,10); // -1=New entry, else index
  if (n<0) arr.push(e); else arr[n]=e;
  arr=arr.sort(CompNames); x.value=arr.join('|');
  ShowBox(0,crew); DspList(crew)
}

// Add or edit cargo item to list depending on nr field
function AddCDC()
{ var e,i,j,k,x,arr=new Array(),f=new Array(),inv=';|<>"';
  allow(document.cdcf.cdc_a,".0123456789");
  f[0]=GetOption(document.cdcf.un_numbers);
  f[1]=document.cdcf.cdc_a.value;
  f[2]=GetOption(document.cdcf.cdc_u);
  f[3]=GetOption(document.cdcf.cdc_c);
  f[4]=GetOption(document.cdcf.cdc_s);
  f[5]=GetOption(document.cdcf.cdc_port);
  f[6]=document.cdcf.cdc_place.value;
  if (f[0]<'A')
  { alert('Missing UN number'); document.cdcf.un_numbers.focus(); return}
  if (f[1].length<1 || f[2]<'A')
  { alert('Missing amount or units'); document.cdcf.cdc_u.focus(); return}
  i=f[1].indexOf('.'); if (i<0) i=f[1].length;
  if (i>8 || i<f[1].length-3)
  { alert('Amount: Max 8 digits before decimal, max 2 digits after it'); document.cdcf.cdc_a.focus(); return}
  for (i=0; i<f.length; i++) // Delimiters disallowed in text
  { for (k=0; k<inv.length; k++)
    { if (f[i])
      { j=f[i].indexOf(inv.substr(k,1));
        if (j>=0) f[i]=f[i].substring(0,j)+f[i].substring(j+1);
  } } }
  x=document.f.cdc_list; e=f.join(';');
  if (x.value.length!=0) arr=x.value.split('|');
  n=parseInt(document.cdcf.nr.value,10); // -1=New entry, else index
  if (n<0) arr.push(e); else arr[n]=e;
  arr=arr.sort(CompNames); x.value=arr.join('|');
  ShowCDC(0); DspCDC()
}

// Edit cargo list entry
function EditCDC(n)
{ var x,arr=new Array(), f=new Array();
  ShowCDC(1); x=document.f.cdc_list;
  document.cdcf.nr.value=n; // List index
  arr=x.value.split('|'); f=arr[n].split(';');
  SetOption(document.cdcf.un_numbers,f[0]);
  document.cdcf.cdc_a.value=f[1];
  SetOption(document.cdcf.cdc_u,f[2]);
  SetOption(document.cdcf.cdc_c,f[3]);
  SetStates(document.cdcf.cdc_c,document.cdcf.cdc_s);
  SetOption(document.cdcf.cdc_s,f[4]);
  SetPorts (document.cdcf.cdc_c,document.cdcf.cdc_s,document.cdcf.cdc_port);
  SetOption(document.cdcf.cdc_port,f[5]);
  document.cdcf.cdc_place.value=f[6]
}

// Edit passenger or crew entry
function Edit(crew,n)
{ var i,x,arr=new Array(),f=new Array();
  if (crew) x=document.f.crew_list; else x=document.f.psgr_list;
  ShowBox(1,crew);
  document.nwf.nr.value=n; // List index
  arr=x.value.split('|'); f=arr[n].split(';');
  SetOption(document.nwf.crew_p,f[0]);
  document.nwf.lastn.value=f[1];
  document.nwf.first.value=f[2];
  document.nwf.middl.value=f[3];
  document.nwf.birth.value=f[4];
SetOption(document.nwf.sex,f[5]);
  SetOption(document.nwf.nation,f[6]);
  SetOption(document.nwf.resid,f[7]);
  SetOption(document.nwf.id_type,f[8]);
  document.nwf.id_nr.value=f[9];
  SetOption(document.nwf.id_c,f[10])
  SetOption(document.nwf.emb_c,f[11]); // embark
  SetStates(document.nwf.emb_c,document.nwf.emb_s);
  SetOption(document.nwf.emb_s,f[12]);
  SetPorts (document.nwf.emb_c,document.nwf.emb_s,document.nwf.emb_port);
  SetOption(document.nwf.emb_port,f[13]);
  document.nwf.emb_place.value=f[14];
  document.nwf.emb_date.value =f[15];
  SetOption(document.nwf.deb_c,f[16]); // debark
  SetStates(document.nwf.deb_c,document.nwf.deb_s);
  SetOption(document.nwf.deb_s,f[17]);
  SetPorts (document.nwf.deb_c,document.nwf.deb_s,document.nwf.deb_port);
  SetOption(document.nwf.deb_port,f[18]);
  document.nwf.deb_place.value=f[19];
  document.nwf.deb_date.value =f[20];
  document.nwf.exp_date.value =f[21];
  for(i=0; i<visa_codes.length; i++)
  { if (visa_codes[i]==f[22])
    { document.nwf.visa_st.selectedIndex=i+1; break
  } }
  document.nwf.visa_fo.value=f[23];
  document.nwf.visa_co.value=f[24];
  document.nwf.addr_street.value=f[25];
  document.nwf.addr_city.value=f[26];
  SetOption(document.nwf.addr_state,f[27]);
  document.nwf.addr_zip.value=f[28];
  document.nwf.cabin.value=f[29];
  document.nwf.phone.value=f[30];
  SetOption(document.nwf.lsm,f[31])
}

// Fill option list x with array a
function FillOpts(x,a)
{ var i,n;
  x.options.length=0; n=new Option('-'); x.options[0]=n;
  for (i=0;i<a.length;i++)
  { n=new Option(a[i]);
    x.options[x.options.length]=n
  } x.selectedIndex=0
}

// Sets selection index of box x to string s
function SetOption(x,s)
{ var i;
  for (i=0; i<x.options.length; i++)
  { if (x.options[i].text==s || x.options[i].value==s)
    { x.selectedIndex=i; break
} } }

// Get text from option field
function GetOption(x)
{ var i=x.selectedIndex, s='';
  if (i>=0)
  { s=x.options[i].value; if (s=='') s=x.options[i].text;
  } return s
}

// Display crew (1) or passengers list (0) as a table
function DspList(crew)
{ var e,i,j,k,s,v,ls,arr=new Array(),f=new Array();
  if (crew!=0) { v=document.f.crew_list.value; s="tbl_crew" }
  else { v=document.f.psgr_list.value; s="tbl_psgr" }
  e='<table border="1" cellpadding="2" cellspacing="0" style="border-collapse:collapse">';
  e+='<tr style="background:#F0F0F0">';
  if (crew) e+='<td>Position</td>';
  e+='<td>Last Name</td><td>First Name</td><td>Middle Name</td><td>Date of Birth</td>';
  e+='<td><b><a href="javascript:ShowBox(1,'+crew+')">Add Entry</a></b></td></tr>\n';
  if (v.length!=0)
  { arr=v.split('|'); ls=0; if (crew) k=0; else k=1;
    for (i=0; i<arr.length; i++)
    { f=arr[i].split(';'); e+='<tr>';
      if (crew && f[31]=="Yes") ls++;
      for (j=k; j<5; j++) e+="<td>"+f[j]+"&nbsp;</td>";
      e+='<td><a href="javascript:Del('+crew+","+i+')">Del</a>/';
      e+='<a href="javascript:Edit('+crew+','+i+')">Edit</a></td></tr>\n';
  } }
  document.getElementById(s).innerHTML=e+'</table>';
  if (crew && document.f.longshoreman_work_declaration.selectedIndex==1 && ls==0) return false
  return true
}

// Display cargo list as a table
function DspCDC()
{ var c,e,i,j,s,v,arr=new Array(),f=new Array();
  s="tbl_cdc"; v=document.f.cdc_list.value;
  if (document.f.cdc_on_board.checked)
  { e='<br><table border="1" cellpadding="2" cellspacing="0" style="border-collapse:collapse">';
    e+='<tr style="background:#F0F0F0"><td>UN number</td><td>Amount</td><td>Unit</td><td>Destination port</td>';
    e+='<td><b><a href="javascript:ShowCDC(1)">Add Entry</a></b></td></tr>\n';
    if (v.length!=0)
    { arr=v.split('|');
      for (i=0; i<arr.length; i++)
      { f=arr[i].split(';'); e+='<tr>';
        for (j=0; j<f.length; j++)
        { if (j==0 || j==6) c=Shortname(f[j]); else c=f[j];
          if (c=='') c='?';
          if (j<3 || j==5) e+="<td>"+c+"&nbsp;</td>"
        }
        e+='<td><a href="javascript:DelCDC('+i+')">Del</a>/';
        e+='<a href="javascript:EditCDC('+i+')">Edit</a></td></tr>\n';
    } } e+='</table>'
  } else e='';
  document.getElementById(s).innerHTML=e
}

// Short UN_number text
function Shortname(s)
{ var i=s.length;
  if (i>53) { return s.substr(0,50)+'...' }
  else { return s }
}

// Delete crew (1) or passenger (0) from list
function Del(crew,n)
{ var i,x,arr=new Array(),f=new Array();
  if (crew) x=document.f.crew_list; else x=document.f.psgr_list;
  arr=x.value.split('|'); f=arr[n].split(';');
  if (confirm('Delete "'+f[2]+' '+f[3]+' '+f[1]+'" from list?'))
  { for (i=n; i<arr.length-1; i++) arr[i]=arr[i+1];
    arr.pop(); x.value=arr.join('|'); DspList(crew)
} }

// Delete cargo from list
function DelCDC(n)
{ var i,x,arr=new Array(),f=new Array();
  x=document.f.cdc_list;
  arr=x.value.split('|');
  f=arr[n].split(';');
  if (confirm('Delete "'+f[0]+'" from list?'))
  { for (i=n; i<arr.length-1; i++) arr[i]=arr[i+1];
    arr.pop(); x.value=arr.join('|'); DspCDC()
} }

// Case-insensitive compare for sorting names
function CompNames(a,b)
{ var a1,b1;
  a1=a.toUpperCase(); b1=b.toUpperCase();
  if (a1<b1) return -1; else if (a1>b1) return 1; else return 0
}

// Shift last foreign ports down (1) or up (-1)
function ShiftForeign(n)
{ var i,j,v1,v2,v3,v4,v5;
  if (n>0) { n1=4; n2=-1; n3=0 } else { n1=2; n2=7; n3=6 }
  { for (i=n1; i!=n2; i=i-n)
    { j=i+n;
      if (i==n3) { v1=-1; v2=-1; v3=''; v4=''; v5='' } else
      { v1=document.getElementsByName("previous_country"+i)[0].selectedIndex;
        v2=document.getElementsByName("previous_port_name"+i)[0].selectedIndex;
        v3=document.getElementsByName("previous_place"+i)[0].value;
        v4=document.getElementsByName("arrival_dt"+i)[0].value;
        v5=document.getElementsByName("departure_dt"+i)[0].value;
      }
      document.getElementsByName("previous_country"+j)[0].selectedIndex=v1;
      SetFPorts(document.getElementsByName("previous_country"+j)[0],document.getElementsByName("previous_port_name"+j)[0]);
      document.getElementsByName("previous_port_name"+j)[0].selectedIndex=v2;
      document.getElementsByName("previous_place"+j)[0].value=v3;
      document.getElementsByName("arrival_dt"+j)[0].value=v4;
      document.getElementsByName("departure_dt"+j)[0].value=v5;
} } }

// Returns true if date is in format yyyy-mm-dd
function ValidDate(e,o) // o=Field optional
{ var i;
 if (o && e=='') return true;
  else
  { if (e.substr(4,1)!='-' || e.substr(7,1)!='-' || e.length!=10) return false;
    i=parseInt(e.substr(0,4),10); if (i<1910 || i>2199) return false;
    i=parseInt(e.substr(5,2),10); if (i<1 || i>12) return false;
    i=parseInt(e.substr(8,2),10); if (i<1 || i>31) return false;
    else return true
} }

// Returns true if time format is valid, adds :ss if required
function ValidTime(x,o) // o=Field optional
{ var i,e=x.value;
  if (o && e=='') return true;
  else
  { if (e.length==5) { e+=":00"; x.value=e }
    if(e.substr(2,1)!=':' || e.substr(5,1)!=':' || e.length!=8) return false;
    i=parseInt(e.substr(0,2),10); if (i<0 || i>23) return false;
    i=parseInt(e.substr(3,2),10); if (i<0 || i>59) return false;
    i=parseInt(e.substr(6,2),10); if (i<0 || i>59) return false;
    else return true
} }

// Warning message
function warn(s)
{ if (document.f.sendnow.checked)
  { alert(s); return false } // Send: No errors allowed
  else return confirm(s+"\nSave anyway?") // Save only
}

// Allows only 0-9, a-z and chars in s for input field x
function allow(x,s)
{ var c,i,n="",f=0,t=x.value;
  for (i=0; i<t.length; i++)
  { c=t.charAt(i);
    if ((c<'a'||c>'z')&&(c<'A'||c>'Z')&&(c<'0'||c>'9')) if(s.indexOf(c)<0) c='';
    if (f || c>' ') { n+=c; f=1 } // Remove leading spaces
  } x.value=n;
}

// Check NOAD form before submitting
function CheckForm()
{ var i,d,ym=DtStr(),x,s,p,r=true,ar=document.f.notice_type.selectedIndex==0;
  // List of mandatory fields
  var m=new Array("call_sign","id_type","id_num","owner","operator","flag",
   "class_society","charterer","oce","rep_name","rep_email",
   "voyage_type","city","co_name","co_phone");
  // Corresponding field text
  var f=new Array("Vessel: Call Sign","Vessel: ID type","Vessel: ID Number","Vessel: Owner",
   "Vessel: Operator","Vessel: Flag","Vessel: Class society","Vessel: Charterer","Vessel: Condition",
   "Reporting: Name","Reporting: E-mail","Arr./Dep.: Voyage Type","Arr./Dep.: City",
   "Arr./Dep.: Contact name","Arr./Dep.: Contact Phone");
  // License key?
  s=document.f.key.value; i=s.indexOf(',');
  if (s.length<16 || i<2) { alert("Missing license key"); return false }
  s=s.substr(i+1,10); // Check license expiration
  if (ym>s) { alert("The license key has expired.\nPlease contact Marlink."); return false }
  if (s.substr(0,7)==ym.substr(0,7)) alert("Warning: Your license key will expire\nthis month.")
  // Mandatory text fields ok?
  if (m.length!=f.length) { alert("Error in warning text table"); return false }
  for (i=0; i<m.length; i++)
  { x=document.getElementsByName(m[i])[0];
    if (x.type=="text") s=x.value;  else s=GetOption(x);
    if (s=='' || s=='-') return warn(f[i]+" missing")
  }
  // Longshoreman declaration?
  if (document.f.longshoreman_work_declaration.selectedIndex==1)
  { if (document.f.ina258_exemption_code.selectedIndex<1)
      return warn("Vessel: INA258 must be selected for longshoreman work.");
    if (!DspList(true)) return warn("Longshoreman work declaration\nbut no corresponding crew member.");
  }
  // Parse text fields
  allow(document.f.voyage_number,". -/\\");
  allow(document.f.call_sign,"- /\\");
  allow(document.f.id_num," /\\");
  allow(document.f.owner,"&().,;+ '-\\/\"");
  allow(document.f.operator,"&()., '-\\/");
  allow(document.f.rep_name,"., '-\\/");
  allow(document.f.rep_comp,"&.,;() '-\\/\"");
  allow(document.f.rep_phone," ()-+\\/");
  allow(document.f.rep_fax," ()-+\\/");
  allow(document.f.charterer,"&.,() '-\\/");
  allow(document.f.oce_desc," .,()'-/");
  allow(document.f.facility," .,()'-/");
  allow(document.f.cso_name,"., '-");
  allow(document.f.cso_phone," ()-+\\/");
  allow(document.f.cso_fax," ()-+\\/");
  allow(document.f.city,"., '-");
  allow(document.f.co_name,"&., '-");
  allow(document.f.co_comp,"&.,()'-\\/");
  allow(document.f.co_phone," ()-+\\/");
  allow(document.f.co_fax," ()-+\\/");
  // Dates and times ok?
  if (!ValidDate(document.f.depart_dt.value,false) || ar && !ValidDate(document.f.arrive_dt.value,false))
   return warn("Arr./Dep.: Invalid date, use yyyy-mm-dd");
  if (!ValidDate(document.f.next_arr_dt.value,false) || ar && !ValidDate(document.f.next_dep_dt.value,false))
   return warn("Arr./Dep.: Invalid last/next port arr./dep. date");
  if (document.f.comp_agency.selectedIndex>0)
  { if (!ValidDate(document.f.comp_iss_dt.value,false) || !ValidDate(document.f.comp_exp_dt.value,false))
   return warn("Vessel: Invalid complicance certificate date");
  }
  if (document.f.sfty_agency.selectedIndex>0)
  { if (!ValidDate(document.f.sfty_iss_dt.value,false) || !ValidDate(document.f.sfty_exp_dt.value,false))
    return warn("Vessel: Invalid safety certificate date");
  }
  if (!ValidTime(document.f.depart_time,false) || ar && !ValidTime(document.f.arrive_time,false))
   return warn("Arr./Dep.: Invalid time");
  if (!ar && !ValidTime(document.f.next_arr_t,false))
   return warn("Arr./Dep.: Invalid next port arrive time");
  if (!ValidDate(document.f.issc_iss_dt.value,true))
   return warn("ISSC: Invalid issue date");
  for (i=1; i<6; i++) // Last foreign ports list
  { if (document.getElementsByName("previous_country"+i)[0].selectedIndex>0) // Country selected?
    { if (document.getElementsByName("previous_port_name"+i)[0].selectedIndex==0
      && document.getElementsByName("previous_place"+i)[0].value=='')
        return warn("Last Ports: Missing port or place #"+i); // if yes, all other fields required
      p=document.getElementsByName("arrival_dt"+i)[0].value;
      if (!ValidDate(p,false))
        return warn("Last Ports: Missing or erroneous arrival date #"+i);
      s=document.getElementsByName("departure_dt"+i)[0].value;
      if (!ValidDate(s,false) || s<p)
        return warn("Last Ports: Missing or erroneous departure date #"+i);
  } } // Other things...
  if (document.f.vessel_response_plan.selectedIndex==0 && NoNum(document.f.vrp_number.value))
    return warn("Vessel: VRP number missing or erroneous");
  s=document.f.vessel_tonnage.value;
  if (document.f.less_than_300gt.selectedIndex==0 && s>299 || NoNum(s))
    return warn("Vessel: Error in vessel tonnage");
  s=document.f.mmsi_number.value; i=s.length;
  if (i>0 && (i<9 || NoNum(s)))
    return warn("Vessel: MMSI number must have 9 digits");
  if (document.f.port_name.selectedIndex<1 && document.f.place.value=='' )
    return warn("Arr./Dep.: Missing port or place");
  if (document.f.next_port.selectedIndex<1 && document.f.next_place.value=='')
    return warn("Arr./Dep.: Missing last/next port or place");
  i=document.f.id_num.value.length;
  if (document.f.id_type.selectedIndex==1)
  { if (i!=7) return warn("Error in vessel IMO ID Number");
  } else if (i<6) return warn("Error in vessel Official Number");
  if (document.f.in_ballast.selectedIndex==0)
  { if (document.f.general_desc.value=='') return warn('Cargo: Description required if not in ballast')
  }
  else
  { if (document.f.general_desc.value!='') return warn('Cargo: No description please if in ballast');
    if (document.f.cdc_on_board.checked==true) return warn('Cargo: No CDC if in ballast');
  }
  if (document.f.cdc_on_board.checked)
  { if (document.f.cdc_list.value=='')
     return warn("Cargo: List required if dangerous cargo on board");
  } else document.f.cdc_list.value=''; // Clear list if CDC unchecked
  if (MailErr(document.f.rep_email.value))
   return warn("Reporting: E-mail address missing or erroneous");
  if ((NoNum(document.f.lat_deg.value) || NoNum(document.f.lat_min.value) || NoNum(document.f.lat_sec.value)
   || NoNum(document.f.long_deg.value) || NoNum(document.f.long_min.value)|| NoNum(document.f.long_sec.value)
   || document.f.lat_deg.value>90 || document.f.lat_min.value>59 || document.f.lat_sec.value>59
   || document.f.long_deg.value>180 || document.f.long_min.value>59 || document.f.long_sec.value>59)
   && document.f.location_desc.value=='') return warn("Reporting: Location missing or erroneous");
  if (document.f.crew_list.value=='') return warn("Crew list missing");
  return true
}

// True if argument is empty or not a number
function NoNum(s)
{ var i,c;
  if (s=='') return true;
  for (i=0; i<s.length; i++)
  { c=s.substr(i,1); if (c<'0' || c>'9') return true
  } return false
}

// Returns current date as yyyy-mm-dd
function DtStr()
{ var d,ym;
  d=new Date(); ym=d.getUTCFullYear()+'-';
  i=d.getUTCMonth()+1; if (i<10) ym+='0'+i; else ym+=i;
  ym+='-'; i=d.getUTCDate(); if (i<10) ym+='0'+i; else ym+=i;
  return ym
}

// Fill option list f2 with array a2 depending on selected item of a1 in option list f1,
// e.g. ports that match the selected U.S. state
function SubList(f1,a1,f2,a2)
{ var i,n,s;
  i=f1.selectedIndex;
  if (i>=0)
  { s=f1.options[i].text;
    f2.options.length=0;
    n=new Option('-'); f2.options[0]=n;
    for (i=0;i<a1.length;i++)
    { if (s==a1[i])
      { n=new Option(a2[i]);
        f2.options[f2.options.length]=n
    } }
    f2.selectedIndex=0
} }

// Set port list z depending on country box x and state box y
function SetPorts(x,y,z)
{ var s,w,n;
  z.options.length=0; n=new Option('-'); z.options[0]=n;
  s=GetOption(x); w='';
  if (s.toUpperCase()=="UNITED STATES")
   SubList(y,usportst,z,usports);
  else
  { for (i=0; i<countries.length; i++) // Search ISO code
     if (countries[i]==s) { w=countriso[i]; break }
    if (w!='')
    { for (i=0; i<fiso.length; i++) // Get ports for this ISO code
      { if (w==fiso[i])
        { n=new Option(fports[i]); z.options[z.options.length]=n
  } } } }
  z.selectedIndex=0
}

// Fill states list y if option x points to "UNITED STATES"
function SetStates(x,y)
{ if (GetOption(x).toUpperCase()=="UNITED STATES")
   FillOpts(y,usstates);
  else FillOpts(y,'');
  y.selectedIndex=0
}

// Fill last foreign port list z depending on country box x
function SetFPorts(x,z)
{ var s,w,n;
  z.options.length=0; n=new Option('-'); z.options[0]=n;
  s=GetOption(x); w='';
  for (i=0; i<countries.length; i++) // Search ISO code
   if (countries[i]==s) { w=countriso[i]; break }
  if (w!='')
  { for (i=0; i<fiso.length; i++) // Get ports for ISO code
    { if (w==fiso[i])
      { n=new Option(fports[i]); z.options[z.options.length]=n
  } } }
  z.selectedIndex=0
}

// Set visibility of options for longshoreman
function SetLongShore()
{ var v;
  if (document.f.longshoreman_work_declaration.selectedIndex==1)
   v="visible"; else v="hidden";
  document.f.ina258_exemption_code.style.visibility=v;
  document.getElementById("ina258").style.visibility=v
}

// Ask to change transaction type: 0=initial, 1=update
function AskType(t)
{ if (t!=document.f.notice_transaction_type.selectedIndex)
   if (confirm('Change transaction type to "'+document.f.notice_transaction_type.options[t].value+'"?'))
   { document.f.notice_transaction_type.selectedIndex=t; SetID()
}  }
